clear all,close all,clc
%%   Read in the image 
load('blurredimage2.mat','blurred')
figure
subplot(2,1,1)
image(blurred), axis image
title('Double Precision Input (blurred) Image')
%% Determine the size of the image supplied
pad = 24;
imsize =  size(blurred);
xsize = imsize(1) + pad;
ysize = imsize(2) + pad;
% Take fft of image
fftblur = fft2(blurred,xsize,ysize);
%---------------------------------
%% Design the inverse filter
%  Use a gaussian kernel from the image processing toolbox
hsize=25;
sigma = 3;
h = fspecial('gaussian', hsize, sigma);
ffth = fft2(h,xsize,ysize);
% Create the inverse filter - this is just the simple form:
fftinvh = 1./ffth;
% figure
% mesh(fftshift(abs(fftinvh)))
% title('Inverse Filter Magnitude')
%----------------------------------
%% Filter the image
fftdeblur = zeros(xsize,ysize,3);
for i=1:3
    fftdeblur(:,:,i) = fftinvh.*fftblur(:,:,i);
end
%% Inverse fft and Color Intensity Scaling
deblurred = abs(ifft2(fftdeblur));
%  Normalize the pixel intensity for the whole image
%  to set all values in the range 0 -- 1 (already all are positive)
maxpix = max(max(max(max(deblurred))),1);
deblurred = deblurred/maxpix;
% Show the image
subplot(2,1,2)
image(deblurred), axis image
title('Double Precision Output (deblurred) Image')


